# Copyright (c) 2025 CenturyArks Co.,Ltd.
#
# These source code may be used (including the use of modified source code) only when using
# CenturyArks's products or services.
#
# Although we have confirmed that it works in the copyright holder's environment, we cannot guarantee that
# there will be no defects.
#
# If you modify the source code, do not remove the copyright notice.
#
# Copyright holder shall not be liable for any claim, damages or other liability arising
# from or relating to the source code or arising from the use or other dealings in the software.

from multiprocessing import Lock, shared_memory

import numpy as np


class SharedMemoryImage:
    def __init__(self, name='my_shm', create=False, lock=None, shape=(720, 1280, 3)):
        image_size = int(np.prod(shape))
        self.shm = shared_memory.SharedMemory(name=name, create=create, size=image_size)
        self.image = np.ndarray(shape, dtype=np.uint8, buffer=self.shm.buf)
        self.lock = lock or Lock()

    def update_image(self, new_image: np.ndarray):
        with self.lock:
            self.image[:] = new_image

    def get_image(self) -> np.ndarray:
        with self.lock:
            return self.image

    def close(self):
        self.shm.close()

    def unlink(self):
        self.shm.unlink()
