# Copyright (c) 2025 CenturyArks Co.,Ltd.
#
# These source code may be used (including the use of modified source code) only when using
# CenturyArks's products or services.
#
# Although we have confirmed that it works in the copyright holder's environment, we cannot guarantee that
# there will be no defects.
#
# If you modify the source code, do not remove the copyright notice.
#
# Copyright holder shall not be liable for any claim, damages or other liability arising
# from or relating to the source code or arising from the use or other dealings in the software.


class SharedString:
    def __init__(self, manager, initial_value: str = ''):
        self.value = manager.Value('s', initial_value.encode('utf-8'))

    def set(self, new_value: str):
        self.value.value = new_value.encode('utf-8')

    def get(self) -> str:
        return self.value.value.decode('utf-8')
