# Copyright (c) 2025 CenturyArks Co.,Ltd.
#
# These source code may be used (including the use of modified source code) only when using
# CenturyArks's products or services.
#
# Although we have confirmed that it works in the copyright holder's environment, we cannot guarantee that
# there will be no defects.
#
# If you modify the source code, do not remove the copyright notice.
#
# Copyright holder shall not be liable for any claim, damages or other liability arising
# from or relating to the source code or arising from the use or other dealings in the software.

from multiprocessing.synchronize import Lock as LockType
from typing import Optional

from shared_image import SharedMemoryImage
from shared_params import SharedParams


class SharedContext:
    def __init__(self, name='my_shm', create=False, lock=None, shared_params=None):
        self.image = SharedMemoryImage(name=name, create=create, lock=lock)

        if shared_params is None:
            raise ValueError("SharedParams must be provided")

        self.params = shared_params

    def close(self):
        self.image.close()

    def unlink(self):
        self.image.unlink()


# Singleton-style accessor
_ctx: Optional[SharedContext] = None


def init_ctx(name: str, create: bool, lock: LockType, shared_params: SharedParams):
    global _ctx
    if _ctx is None:
        _ctx = SharedContext(name, create, lock, shared_params)


def get_ctx() -> SharedContext:
    if _ctx is None:
        raise RuntimeError("SharedContext has not been initialized. Call init_ctx() first.")
    return _ctx


def set_ctx(context: SharedContext):
    global _ctx
    _ctx = context
