# Copyright (c) 2025 CenturyArks Co.,Ltd.
#
# These source code may be used (including the use of modified source code) only when using
# CenturyArks's products or services.
#
# Although we have confirmed that it works in the copyright holder's environment, we cannot guarantee that
# there will be no defects.
#
# If you modify the source code, do not remove the copyright notice.
#
# Copyright holder shall not be liable for any claim, damages or other liability arising
# from or relating to the source code or arising from the use or other dealings in the software.

from multiprocessing.managers import SyncManager

from shared_string import SharedString


class SharedParams:
    def __init__(self, manager: SyncManager):

        # Program termination control
        self.is_alive = manager.Value('b', True)

        # Dual video synchronized recording control
        self.is_evt_recording = manager.Value('b', False)

        # Dual video synchronized external trigger count control
        self.ext_trigger_count = manager.Value('q', 0)

        # Str for dual video synchronized recording control
        self.recording_name = SharedString(manager, "")

        # Event to confirm camera startup
        self.event_camera_open_proc = manager.Event()
        self.event_camera_err_flag = manager.Event()
        self.frame_camera_open_proc = manager.Event()
        self.frame_camera_err_flag = manager.Event()
